<?php
global $pdo, $currentUser;

// ট্রানজেকশন হিস্ট্রি
$stmt = $pdo->prepare("
    SELECT * FROM transactions 
    WHERE user_id = ? 
    ORDER BY created_at DESC 
    LIMIT 10
");
$stmt->execute([$currentUser['id']]);
$transactions = $stmt->fetchAll();
?>
<!-- WALLET PAGE -->
<div id="wallet-view">
    <div class="page-nav">
        <i class="fas fa-arrow-left" onclick="showPage('profile')"></i>
        <h3>My Wallet</h3>
    </div>
    
    <div class="wallet-card-main">
        <p>Total Balance</p>
        <h1 id="wallet-total-big">৳<?php echo number_format($currentUser['depositBalance'] + $currentUser['winningBalance'], 2); ?></h1>
        <p class="turnover-txt">Turnover Remaining: ৳<span id="wallet-turnover"><?php echo number_format($currentUser['turnoverReq'], 2); ?></span></p>
        <div class="wallet-stats">
            <div><span>Deposit</span><h4 id="wallet-dep">৳<?php echo number_format($currentUser['depositBalance'], 2); ?></h4></div>
            <div><span>Winning</span><h4 id="wallet-win">৳<?php echo number_format($currentUser['winningBalance'], 2); ?></h4></div>
        </div>
    </div>
    
    <div class="wallet-btns-row">
        <button class="btn-deposit" onclick="showPage('deposit')">Deposit</button>
        <button class="btn-withdraw" onclick="showPage('withdraw')">Withdraw</button>
    </div>
    
    <div class="txn-history-sec">
        <h4>Transaction History</h4>
        <div class="table-wrap">
            <table id="txn-table">
                <thead>
                    <tr>
                        <th>Type</th>
                        <th>Amount</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody id="txn-body">
                    <?php foreach ($transactions as $txn): ?>
                    <tr>
                        <td><?php echo $txn['type']; ?></td>
                        <td><?php echo number_format($txn['amount'], 2); ?></td>
                        <td><?php echo $txn['description'] ?: 'Completed'; ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>